package main

import (
	"github.com/veandco/go-sdl2/img"
	"github.com/veandco/go-sdl2/sdl"
)

const (
	rymdskeppTexturePath            string = "res/rymdskepp.png"
	rymdskeppTextureWidth           int32  = 64
	rymdskeppTextureHeight          int32  = 64
	rymdskeppJetBeamOffsetX         int32  = 24
	rymdskeppJetBeamOffsetY         int32  = 48
	rymdskeppJetBeamWidth           int    = 10
	rymdskeppJetBeamHeight          int    = 16
	rymdskeppJetBeamYellowParticles int    = 20
	rymdskeppJetBeamOrangeParticles int    = 40
)

var rymdskeppAsset []byte
var rymdskeppRWops *sdl.RWops
var rymdskeppSurface *sdl.Surface

func loadRymdskepp() *sdl.Surface {
	if rymdskeppSurface == nil {
		var err error
		rymdskeppAsset, err = Asset(rymdskeppTexturePath)
		if err != nil {
			panic(err)
		}
		rymdskeppRWops, err = sdl.RWFromMem(rymdskeppAsset)
		if err != nil {
			panic(err)
		}
		rymdskeppSurface, err = img.LoadPNGRW(rymdskeppRWops)
		if err != nil {
			panic(err)
		}
	}
	return rymdskeppSurface
}

type Rymdskepp struct {
	sprite  *Sprite
	jetBeam *JetBeamParticleEffect
	x       int32
	y       int32
	show    bool
}

func NewRymdskepp(renderer *sdl.Renderer) *Rymdskepp {
	rymdskepp := new(Rymdskepp)
	rymdskepp.show = true
	rymdskepp.sprite = NewSprite(renderer, loadRymdskepp())
	rymdskepp.jetBeam = NewJetBeamParticleEffect(
		0.0,
		0.0,
		rymdskeppJetBeamWidth,
		rymdskeppJetBeamHeight,
		rymdskeppJetBeamYellowParticles,
		rymdskeppJetBeamOrangeParticles)
	return rymdskepp
}

func (rymdskepp *Rymdskepp) Update(deltaTime float32) {
	rymdskepp.jetBeam.Update(deltaTime,
		float32(rymdskepp.x+rymdskeppJetBeamOffsetX),
		float32(rymdskepp.y+rymdskeppJetBeamOffsetY))
}

func (rymdskepp *Rymdskepp) Draw(renderer *sdl.Renderer) {
	if !rymdskepp.show {
		return
	}
	rymdskepp.jetBeam.Draw(renderer)
	rymdskepp.sprite.Draw(renderer, rymdskepp.x, rymdskepp.y)
}

func (rymdskepp *Rymdskepp) Width() int32 {
	return rymdskeppTextureWidth
}

func (rymdskepp *Rymdskepp) Height() int32 {
	return rymdskeppTextureHeight
}
